* Encoding: UTF-8.

*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Nmero de fallecidos por cada 100 siniestros de trnsito*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2019 - Siniestros de Trnsito*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        11 de Diciembre del 2018*
* Fecha ltima modificacin:  30 de Marzo del 2020*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.
* Gabriela Hidalgo.
* Jorge Len.

*Instrucciones:
*1.- Descarga la base de datos de Siniestros de Trnsito "2019_SINIESTROS_DE_TRANSITO_BDD" en formato SPSS de la pgina
      web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2019_SINIESTROS_DE_TRANSITO_BDD".

DATASET NAME SINIESTROS.
DATASET COPY SINIESTROS.
DATASET  ACTIVATE SINIESTROS.

**********************************************************************************************************************.
***********NMERO DEFALLECIDOS POR CADA 100 SINIESTROS DE TRNSITO - PROVINCIAL***.
**********************************************************************************************************************.

***Creando variable nmero de siniestros***.
COMPUTE NST=1.
FORMATS NST (F5.0).
VARIABLE LABELS NST 'Nmero de siniestros'.
EXECUTE.

***Agregando la base de datos a nivel de provincia***.
DATASET DECLARE TASA_FALLECIDO.
AGGREGATE
  /outfile='TASA_FALLECIDO'
  /break=PROVINCIA
  /NST=SUM(NST)
  /NUM_FALLECIDO=SUM(NUM_FALLECIDO).

**Utilizacin de la base de datos agregada***.
DATASET  ACTIVATE TASA_FALLECIDO.

***Preparando la base para el clculo del indicador***.
VARIABLE LABELS NST 'Nmero de siniestros de trnsito'.
FORMATS NST (F10.0).
EXECUTE.

VARIABLE LABELS NUM_FALLECIDO 'Nmero de fallecidos'.
FORMATS NUM_FALLECIDO (F10.0).
EXECUTE.

COMPUTE TMS=(NUM_FALLECIDO/(NST/100)).
VARIABLE LABELS TMS 'Nmero de fallecidos por cada 100 siniestros de trnsito'.
FORMATS TMS (F5.0).
EXECUTE.

****CUADRO N 23****.

***Tabulado: Nmero de fallecidos por cada 100 siniestros de trnsito - Provincial***.
TABLES
/OBSERVATION= NUM_FALLECIDO NST TMS
/TABLE= PROVINCIA BY NUM_FALLECIDO + NST + TMS
/STATISTICS=SUM
/TITLE='INDICADORES Siniestros DE TRNSITO, ao 2019'
           'POR PROVINCIA'
           '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Agencia Nacional de Trnsito - ANT 2019'.
EXECUTE.

**********************************************************************************************************************.
************NMERO DE FLLECIDOS POR CADA 100 SINIESTROS DE TRNSITO - NACIONAL***.
**********************************************************************************************************************.

*Usando base de datos "2019_SINIESTROS_DE_TRANSITO_BDD"**.
DATASET ACTIVATE TASA_FALLECIDO.

COMPUTE TOTAL=1.
VARIABLE LABELS TOTAL 'Nacional'.
VALUE LABELS TOTAL 1'NACIONAL'.
FORMATS TOTAL (F10.0).
EXECUTE.

***Agregando la base de datos a nivel nacional***.
DATASET DECLARE TASA_FALLECIDO_N.
AGGREGATE
  /outfile='TASA_FALLECIDO_N'
  /break=TOTAL
  /NST=SUM(NST)
  /NUM_FALLECIDO=SUM(NUM_FALLECIDO).

**Utilizacin de la base de datos agregada***.
DATASET ACTIVATE TASA_FALLECIDO_N.

VARIABLE LABELS NST 'Nmero de siniestros de trnsito'.
FORMATS NST (F10.0).
EXECUTE.

VARIABLE LABELS NUM_FALLECIDO 'Nmero de fallidos'.
FORMATS NUM_FALLECIDO (F10.0).
EXECUTE.

COMPUTE TMS=(NUM_FALLECIDO/(NST/100)).
VARIABLE LABELS TMS 'Nmero de fallecidos por cada 100 siniestros de trnsito'.
FORMATS TMS (F5.0).
EXECUTE.

****CUADRO N 23****.

***Tabulado: Nmero de fallecidos por cada 100 siniestros de trnsito - Nacional***.

TABLES
/OBSERVATION= NUM_FALLECIDO NST TMS
/TABLE= TOTAL BY NUM_FALLECIDO + NST + TMS
/STATISTICS=SUM
/TITLE='INDICADORES Siniestros DE TRNSITO, ao 2019'
           'POR PROVINCIA'
           '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Agencia Nacional de Trnsito - ANT 2019'.
EXECUTE.


DATASET ACTIVATE SINIESTROS. 
DATASET CLOSE TASA_FALLECIDO_N.
DATASET ACTIVATE SINIESTROS. 
DATASET CLOSE TASA_FALLECIDO.








